"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccount = void 0;
exports.getAccountRoute = getAccountRoute;
var _configSchema = require("@kbn/config-schema");
var _errors = require("../../lib/errors");
var _helpers = require("../../lib/helpers");
var _constants = require("../../../../../common/signals/constants");
/*
 *    Copyright 2020 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const getAccount = ({
  clusterClient,
  logger
}) => async (context, request, response) => {
  try {
    const {
      id,
      type
    } = request.params;
    const path = `/_signals/account/${type}/${encodeURIComponent(id)}`;
    const {
      _source,
      _id
    } = await clusterClient.asScoped(request).asCurrentUser.transport.request({
      method: 'get',
      path
    });
    return response.ok({
      body: {
        ok: true,
        resp: {
          ..._source,
          _id: (0, _helpers.getId)(_id)
        }
      }
    });
  } catch (err) {
    if (err.statusCode !== 404) {
      logger.error(`getAccount: ${err.stack}`);
    }
    return response.customError((0, _errors.serverError)(err));
  }
};
exports.getAccount = getAccount;
function getAccountRoute({
  router,
  clusterClient,
  logger
}) {
  router.get({
    path: `${_constants.ROUTE_PATH.ACCOUNT}/{type}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        type: _configSchema.schema.string()
      }, {
        unknowns: 'allow'
      })
    }
  }, getAccount({
    clusterClient,
    logger
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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